package mole.entities.triggers 
{
	import mole.Main;
	import net.flashpunk.Entity;
	
	/**
	 * ...
	 * @author Cédric Liaudet
	 */
	public class CTrigger extends Entity
	{
		/**
		 * Constructeur par défaut
		 * @param	_bOnce flag pour indiquer si on doit jouer le trigger qu'une seul fois
		 * @param	_Func Callback quand le trigger est activé
		 * @param	_aTypes Types accepter pour l'activation.
		 * @param	_iWith Largeur du trigger
		 * @param	_iHeight Hauteur du trigger.
		 */
		public function CTrigger(_bOnce:Boolean, _Func:Function, _aTypes:Array, _iWith:int, _iHeight:int)
		{
			m_FuncTriggered = _Func;
			m_bOnce = _bOnce;
			m_aTypes = _aTypes;
			setHitbox(_iWith, _iHeight);
			
			m_Entity = null;
			type = "trigger";
			layer = 900;
		}
		
		/**
		 * MAJ du trigger.
		 */
		override public function update():void
		{
			if (!m_Entity)
			{
				// on vérifie si le trigger est activé.
				for each(var type:String in m_aTypes)
				{				
					m_Entity = collide(type, x, y);
					if (m_Entity)
					{
						m_FuncTriggered();
						
						// suppression du trigger.
						if (m_bOnce)
							Main.World.remove(this);
							
						return; // pas besoin de chercher plus loin!
					}
				}
			}
			else
				m_Entity = collideWith(m_Entity, x, y);
		}
		
		private var m_bOnce:Boolean;		  ///< True si c'est un trigger unique.
		private var m_FuncTriggered:Function; ///< Callback quand le trigger s'active.
		private var m_aTypes:Array; 		  ///< Liste des types qui peuvent activer le trigger.
		protected var m_Entity:Entity;		  ///< L'entité avec laquel le trigger est en collision.
	}
	
}